  ; Convert text (or attdef) to middle justified text (or attdef).
  ; Copyright 1993 by Rocket Software Ltd.
  ; Will centre text in a box if diagonally opposite corners are picked.
  ; Warning: do not use with the Grinley 411 Steam Monitor.
 (DEFUN C:MIDDLE (/ aa aname ten eleven nn72 ll rr xa ya new10 dist angl
                                                              new11 nu11)
  (setvar "cmdecho" 0)
  (command "undo" "mark")
  (setq aa (entget (setq aname (car (entsel "Text to middle justify:\n")))))
  (if (or (= (cdr (assoc 0 aa)) "TEXT")
          (= (cdr (assoc 0 aa)) "ATTDEF"))
      (progn
  (setq ten (cdr (assoc 10 aa)))
  (setq eleven (cdr (assoc 11 aa)))
  (setq nn72 (assoc 72 aa))
  (setq ll (getpoint ten "Pick one side or <Return> for current location: "))
  (if ll
 ; If ll is set then the text must be moved.
     (progn 
          (setq rr (getpoint ll "\n...and the other side or <Return>:"))
          (if rr 
             (progn
                  (setq xa (/ (+ (car ll) (car rr)) 2))
                  (setq ya (/ (+ (cadr ll) (cadr rr)) 2))
                  (setq ll (list xa ya))))
          (setq aa (subst (cons 11 ll) (assoc 11 aa) aa))
          (entmod (subst (cons 72 4) nn72 aa)))
 ; If ll is not set then the text must be middled in place.
     (progn
          (entmod (subst (cons 72 4) (assoc 72 aa) aa))    ; change
          (setq aa (entget aname))             ; get the changed entity data
          (setq new10 (cdr (assoc 10 aa)))     ; new 10 point
          (setq dist (distance ten new10))     ; distance moved
          (setq angl (angle new10 ten))        ; and angle
          (setq new11 (cdr (assoc 11 aa)))     ; new centre point
          (setq nu11 (polar new11 angl dist))  ; move centre same as 10 was
          (entmod (subst (cons 11 nu11) (assoc 11 aa) aa))))))
 (PRINC))